
function [smoothed] = MAsmooth(X, nback, nfront)
    % MAsmooth creates a smooth moving average of the series by taking the mean
    % of the series around each given date.  For example, the value at observation 50 
    % will be the mean of the series from (50-nback:50+nback).  
    % 
    % If nback and nfront are the same, then it's a centered moving
    % average.  If nfront=0, then it's a purely backward-looking moving
    % average.
    %
    % Function was written by Kyle Matoba for use in the QuarterlyTFP code.
    % Documentation was written by John Fernald 11/5/2011.

    [nrow,ncol] = size(X);
    smoothed = NaN(nrow, ncol);
     
    for j = 1:ncol
        notnanInd = find(~isnan(X(:,j)) & ~isinf(X(:,j)) );
        nNotNan = length(notnanInd);
        thisDat = X(notnanInd, j); % pull out the j^th column, we'll yank the NaNs
        thisSmoothed = NaN(size(thisDat));
        for i = 1:nNotNan
            index = max(i - nback,1):min(i + nfront, nNotNan);
            thisSmoothed(i) = mean(thisDat(index));
        end % i
        smoothed(notnanInd,j) = thisSmoothed;
    end % j
    
end % function

